<?php

require_once("vbautil/class_xml.php");
require_once "vbautil/build_vbamodule_utils.php";

$dirs = array(
	"standard" => array("php"=>"../vba_modules/php", "template"=>"../vba_modules/templates", "module"=>"../../release/vba_modules"),
	"versionist" => array("php"=>"../vba_modules/php", "template"=>"../vba_modules/versionist_templates", "module"=>"../../release/extras/versionist"),
	);

foreach ($dirs as $which=>$dir) {

	echo "Now building ".$which." modules\n";
	$codedir = $dir["php"];
	$templatedir = $dir["template"];
	$outputdir = $dir["module"];
	echo "PHP code read from ".$codedir."\n";
	echo "Templates read from ".$templatedir."\n";
	echo "Modules written to ".$outputdir."\n";

// Total Bandwidth module

	$vba_module = create_vba_module("Site Statistics", "ldm_tot", $codedir."/ldm_tot.php", $templatedir."/ldm_tot.xml");
	add_vba_setting($vba_module, "portal_ldm_tot_days_seen", "adv_portal_ldm_tot", "Days", "Number of days to aggregate downloads", "", "30", "30");
	save_vba_module($vba_module, $outputdir."/ldm_tot.module");
	echo "Created Total Bandwidth module\n";

// Main Categories module

	$vba_module = create_vba_module("Categories", "ldm_cats", $codedir."/ldm_cats.php", $templatedir."/ldm_cats.xml", "links_catbit, links_linkseparator");
	save_vba_module($vba_module, $outputdir."/ldm_cats.module");
	echo "Created Main Categories module\n";

// Newest Categories module

	$vba_module = create_vba_module("Newest Categories", "ldm_newcats", $codedir."/ldm_newcats.php", $templatedir."/ldm_newcats.xml", "links_linkseparator");
	add_vba_setting($vba_module, "portal_ldm_newcats_catids", "adv_portal_newcats", "title", "description");
	add_vba_setting($vba_module, "portal_ldm_newcats_showentries", "adv_portal_newcats", "Entries", "Number of entries to display", "", "5", "5");
	add_vba_setting($vba_module, "portal_ldm_newcats_columns", "adv_portal_newcats", "Columns", "Number of columns", "", "1", "1");
	save_vba_module($vba_module, $outputdir."/ldm_newcats.module");
	echo "Created Newest Categories module\n";

// What's Hot module

	$vba_module = create_vba_module("What's Hot", "ldm_hot", $codedir."/ldm_hot.php", $templatedir."/ldm_hot.xml",
				"links_downloadbit, links_editbit, links_favbit, links_imgmag, links_likebit, links_linkseparator, links_ratebit");

	add_vba_setting($vba_module, "portal_ldm_hot_showentries", "adv_portal_ldm_hot", "Entries", "Number of entries to display", "", "5", "5");
	add_vba_setting($vba_module, "portal_ldm_hot_showperrow", "adv_portal_ldm_hot", "Per row", "Entries to show per row", "", "1", "1");
	add_vba_setting($vba_module, "portal_ldm_hot_hitssince", "adv_portal_ldm_hot", "Days", "Number of days over which to count.  Set to zero to count all hits", "", "0", "0");
	add_vba_setting($vba_module, "portal_ldm_hot_showcategories", "adv_portal_ldm_hot", "Categories", "Comma-separated list of category ids to search.  Leave blank to search all categories");
	add_vba_setting($vba_module, "portal_ldm_hot_showsubcats", "adv_portal_ldm_hot", "Subcategories", "Set to yes to include all subdirectories of selected categories.  Set to no to explore these categories only", "yesno", 0, 0);
	add_vba_setting($vba_module, "portal_ldm_hot_showcatname", "adv_portal_ldm_hot", "Show Category Name", "Include category name in listing", "yesno", "0", "0");
	save_vba_module($vba_module, $outputdir."/ldm_hot.module");
	echo "Created What's Hot module\n";

// What's New module

	$vba_module = create_vba_module("What's New", "ldm_new", $codedir."/ldm_new.php", $templatedir."/ldm_new.xml",
				"links_downloadbit, links_editbit, links_favbit, links_imgmag, links_likebit, links_linkseparator, links_ratebit");

	add_vba_setting($vba_module, "portal_ldm_new_showentries", "adv_portal_ldm_new", "Entries", "Number of entries to display", "", "5", "5");
	add_vba_setting($vba_module, "portal_ldm_new_showperrow", "adv_portal_ldm_new", "Per row", "Entries to show per row", "", "1", "1");
	add_vba_setting($vba_module, "portal_ldm_new_showcategories", "adv_portal_ldm_new", "Categories", "Comma-separated list of category ids to search.  Leave blank to search all categories");
	add_vba_setting($vba_module, "portal_ldm_new_showsubcats", "adv_portal_ldm_new", "Subcategories", "Set to yes to include all subdirectories of selected categories.  Set to no to explore these categories only", "yesno", "0", "0");
	add_vba_setting($vba_module, "portal_ldm_new_showcatname", "adv_portal_ldm_new", "Show Category Name", "Include category name in listing", "yesno", "0", "0");
	save_vba_module($vba_module, $outputdir."/ldm_new.module");
	echo "Created What's New module\n";

// What's New (as thumbs) module

	$vba_module = create_vba_module("New Thumbs", "ldm_new_thumb", $codedir."/ldm_new_thumb.php", $templatedir."/ldm_new_thumb.xml",
				"links_downloadbit, links_editbit, links_favbit, links_imgmag, links_likebit, links_linkseparator, links_ratebit, adv_portal_custom_ldm_new_thumb, adv_portal_custom_ldm_new_thumb_one");

	add_vba_setting($vba_module, "portal_ldm_new_thumb_showentries", "adv_portal_ldm_new_thumb", "Entries", "Number of entries to display", "", "12", "12");
	add_vba_setting($vba_module, "portal_ldm_new_thumb_showthumbsize", "adv_portal_ldm_new_thumb", "Thumbnail size", "Pixels or %", "", "100", "100");
	add_vba_setting($vba_module, "portal_ldm_new_thumb_showperrow", "adv_portal_ldm_new_thumb", "Per row", "Thumbs to show per row", "", "4", "4");
	add_vba_setting($vba_module, "portal_ldm_new_thumb_showcategories", "adv_portal_ldm_new_thumb", "Categories", "Comma-separated list of category ids to search.  Leave blank to search all categories");
	add_vba_setting($vba_module, "portal_ldm_new_thumb_showsubcats", "adv_portal_ldm_new_thumb", "Subcategories", "Set to yes to include all subdirectories of selected categories.  Set to no to explore these categories only", "yesno", "0", "0");
	save_vba_module($vba_module, $outputdir."/ldm_new_thumb.module");
	echo "Created New Thuumbs module\n";

// New Reviews module

	$vba_module = create_vba_module("New Reviews", "ldm_new_reviews", $codedir."/ldm_new_reviews.php", $templatedir."/ldm_new_reviews.xml");
	add_vba_setting($vba_module, "portal_ldm_new_reviews_showentries", "adv_portal_ldm_new_reviews", "Entries", "Number of entries to display", "", 5, 5);
	save_vba_module($vba_module, $outputdir."/ldm_new_reviews.module");
	echo "Created New Reviews module\n";

// Newly Reviewed module

	$vba_module = create_vba_module("Newly Reviewed", "ldm_newly_reviewed", $codedir."/ldm_newly_reviewed.php", $templatedir."/ldm_newly_reviewed.xml");
	add_vba_setting($vba_module, "portal_ldm_newly_reviewed_showentries", "adv_portal_ldm_new_reviewed", "Entries", "Number of entries to display", "", 5, 5);
	save_vba_module($vba_module, $outputdir."/ldm_newly_reviewed.module");
	echo "Created Newly Reviewed module\n";

// Full search module

	$vba_module = create_vba_module("Search Downloads", "ldm_search", $codedir."/ldm_search.php", $templatedir."/ldm_search.xml");
	save_vba_module($vba_module, $outputdir."/ldm_search.module");
	echo "Created Full Search module\n";

// Tagcloud module

	$vba_module = create_vba_module("Keyword TagCloud", "ldm_tagcloud", $codedir."/ldm_tagcloud.php", $templatedir."/ldm_tagcloud.xml");
	add_vba_setting($vba_module, "portal_ldm_tagcloud_limit", "adv_portal_ldm_tagcloud", "Top keywords", "Number of keywords to display", "", "10", "10");
	add_vba_setting($vba_module, "portal_ldm_tagcloud_byhits", "adv_portal_ldm_tagcloud", "Weighting", "0=unweighted, 1=by total hits", "", "0", "0");
	add_vba_setting($vba_module, "portal_ldm_tagcloud_logcurve", "adv_portal_ldm_tagcloud", "Logarithmic fit", "0=no, 1=yes", "", "1", "1");
	add_vba_setting($vba_module, "portal_ldm_tagcloud_minfont", "adv_portal_ldm_tagcloud", "Minimum font size", "px", "", "10", "10");
	add_vba_setting($vba_module, "portal_ldm_tagcloud_maxfont", "adv_portal_ldm_tagcloud", "Maximum font size", "px", "", "36", "36");
	save_vba_module($vba_module, $outputdir."/ldm_tagcloud.module");
	echo "Created Tagcloud module\n";

	echo "Done\n\n";

}

?>